<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';
require_once '../../helpers/tanggal.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

$where = "";
if (!empty($_GET['dari']) && !empty($_GET['sampai'])) {
    $dari   = $_GET['dari'];
    $sampai = $_GET['sampai'];
    $where  = "WHERE DATE(tanggal) BETWEEN '$dari' AND '$sampai'";
}

// Barang masuk
$masuk = $db->query("
    SELECT m.*, s.nama_barang 
    FROM inventory_masuk m
    JOIN inventory_stok s ON m.barang_id = s.id
    $where
    ORDER BY m.tanggal DESC
");

// Barang keluar
$keluar = $db->query("
    SELECT k.*, s.nama_barang 
    FROM inventory_keluar k
    JOIN inventory_stok s ON k.barang_id = s.id
    $where
    ORDER BY k.tanggal DESC
");
?>

<h2>Laporan Inventory</h2>

<form method="get">
    Dari: <input type="date" name="dari" required>
    Sampai: <input type="date" name="sampai" required>
    <button type="submit">Tampilkan</button>
</form>

<hr>

<h3>Barang Masuk</h3>
<table class="table">
    <thead>
        <tr>
            <th>No</th>
            <th>Tanggal</th>
            <th>Barang</th>
            <th>Jumlah</th>
            <th>Keterangan</th>
        </tr>
    </thead>
    <tbody>
        <?php $no=1; while($m = $masuk->fetch_assoc()): ?>
        <tr>
            <td><?= $no++; ?></td>
            <td><?= tanggal($m['tanggal']); ?></td>
            <td><?= $m['nama_barang']; ?></td>
            <td><?= $m['jumlah']; ?></td>
            <td><?= $m['keterangan']; ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<hr>

<h3>Barang Keluar</h3>
<table class="table">
    <thead>
        <tr>
            <th>No</th>
            <th>Tanggal</th>
            <th>Barang</th>
            <th>Jumlah</th>
            <th>Keterangan</th>
        </tr>
    </thead>
    <tbody>
        <?php $no=1; while($k = $keluar->fetch_assoc()): ?>
        <tr>
            <td><?= $no++; ?></td>
            <td><?= tanggal($k['tanggal']); ?></td>
            <td><?= $k['nama_barang']; ?></td>
            <td><?= $k['jumlah']; ?></td>
            <td><?= $k['keterangan']; ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<?php require_once '../../templates/footer.php'; ?>
